import { Link } from "wouter";
import { UserRound, Phone, Mail, MapPin } from "lucide-react";
import { SiLinkedin, SiFacebook, SiX } from "react-icons/si";
import ConsultationCTA from "@/components/ui/consultation-cta";

export default function Footer() {
  const quickLinks = [
    { name: "Home", href: "/" },
    { name: "About Us", href: "/about" },
    { name: "Services", href: "/services" },
    { name: "Join The Team", href: "/join-team" },
    { name: "Get in Touch", href: "/contact" },
  ];

  const services = [
    "Registered Nurses",
    "Care Workers", 
    "Healthcare Assistants",
    "Temporary Staffing",
    "Compliance Support",
  ];

  return (
    <footer className="bg-slate-900 text-white py-12">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Company Info */}
          <div>
            <div className="flex items-center mb-4">
              <img
                src="/smartgad-logo.jpg"
                alt="SmartGad Living Logo"
                className="w-10 h-10 rounded-full object-cover mr-3"
              />
              <div>
                <h3 className="text-lg font-bold">SmartGad Living</h3>
                <p className="text-xs text-slate-400">Healthcare Recruitment</p>
              </div>
            </div>
            <p className="text-slate-300 text-sm leading-relaxed mb-4">
              Leading healthcare recruitment agency connecting qualified professionals with rewarding career opportunities across the UK.
            </p>
            <div className="flex space-x-4">
              <a href="#" className="text-slate-400 hover:text-accent-400 transition-colors" data-testid="link-social-linkedin">
                <SiLinkedin className="text-xl" />
              </a>
              <a href="#" className="text-slate-400 hover:text-accent-400 transition-colors" data-testid="link-social-facebook">
                <SiFacebook className="text-xl" />
              </a>
              <a href="#" className="text-slate-400 hover:text-accent-400 transition-colors" data-testid="link-social-twitter">
                <SiX className="text-xl" />
              </a>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h4 className="font-semibold mb-4">Quick Links</h4>
            <ul className="space-y-2 text-sm">
              {quickLinks.map((link) => (
                <li key={link.name}>
                  <Link
                    href={link.href}
                    className="text-slate-300 hover:text-accent-400 transition-colors"
                    data-testid={`link-footer-${link.name.toLowerCase().replace(/\s+/g, '-')}`}
                  >
                    {link.name}
                  </Link>
                </li>
              ))}
            </ul>
          </div>

          {/* Services */}
          <div>
            <h4 className="font-semibold mb-4">Our Services</h4>
            <ul className="space-y-2 text-sm">
              {services.map((service) => (
                <li key={service}>
                  <span className="text-slate-300">{service}</span>
                </li>
              ))}
            </ul>
          </div>

          {/* Contact Info */}
          <div>
            <h4 className="font-semibold mb-4">Contact Info</h4>
            <div className="space-y-3 text-sm">
              <div className="flex items-center space-x-3">
                <Phone className="text-accent-400 w-4 h-4" />
                <span className="text-slate-300">+44 7832920119</span>
              </div>
              <div className="flex items-center space-x-3">
                <Mail className="text-accent-400 w-4 h-4" />
                <span className="text-slate-300">info@smartgadliving.co.uk</span>
              </div>
              <div className="flex items-start space-x-3">
                <MapPin className="text-accent-400 w-4 h-4 mt-1" />
                <span className="text-slate-300">Portsmouth, United Kingdom</span>
              </div>
            </div>
            
            <div className="mt-4">
              <ConsultationCTA variant="accent" size="sm" />
            </div>
          </div>
        </div>

        <div className="border-t border-slate-700 mt-8 pt-8 text-center">
          <p className="text-slate-400 text-sm">
            © 2025 SmartGad Living Ltd. All rights reserved. |{" "}
            <a href="#" className="hover:text-accent-400 transition-colors">Privacy Policy</a> |{" "}
            <a href="#" className="hover:text-accent-400 transition-colors">Terms of Service</a>
          </p>
        </div>
      </div>
    </footer>
  );
}
