import { Button } from "@/components/ui/button";

export default function Hero() {
  return (
    <section className="relative h-screen bg-cover bg-center bg-no-repeat" style={{ backgroundImage: 'url(/hero-medical-team.jpg)' }}>
      {/* Content */}
      <div className="relative z-10 flex items-center h-full">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 w-full">
          <div className="max-w-3xl">
            <h1 className="text-4xl lg:text-6xl font-bold leading-tight mb-6">
              <span className="text-[#4cd7dc]">Exceptional</span>{" "}
              <span className="text-[#3d59c3]">Care</span>{" "}
              <span className="text-[#3c59c2]">Services</span>
              <br />
              <span className="text-[#3c59c2]">for Peace of Mind</span>
            </h1>
            
            <p className="text-xl text-slate-700 mb-8 leading-relaxed max-w-2xl">
              SmartGad Living provides compassionate home care services across the United Kingdom. From personal care and companionship to specialized dementia support, we deliver professional care that allows you to maintain independence and dignity in your own home.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4">
              <Button
                size="lg"
                className="hover:bg-primary-700 text-white px-8 py-4 text-lg font-semibold rounded-lg bg-[#4cd7dc]"
                data-testid="button-free-consultation"
                onClick={() => {
                  // Navigate to contact page
                  window.location.href = '/contact';
                }}
              >
                Free Consultation
              </Button>
              <Button
                size="lg"
                variant="outline"
                className="border-2 border-white hover:bg-white hover:text-slate-900 px-8 py-4 text-lg font-semibold rounded-lg bg-[#3c59c2] text-[#ffffff]"
                data-testid="button-join-team"
                onClick={() => {
                  // Navigate to join team page
                  window.location.href = '/join-team';
                }}
              >
                Join Our Team
              </Button>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
