import { User, Heart, Clock, Briefcase, GraduationCap, Phone } from "lucide-react";

const services = [
  {
    icon: User,
    title: "Registered Nurses",
    description: "Qualified and experienced registered nurses for hospitals, clinics, and healthcare facilities across the UK.",
    bgColor: "bg-primary-500",
  },
  {
    icon: Heart,
    title: "Care Workers",
    description: "Compassionate care workers providing essential support in residential care homes and community settings.",
    bgColor: "bg-accent-500",
  },
  {
    icon: Clock,
    title: "Temporary Staffing",
    description: "Flexible temporary staffing solutions to cover short-term needs and emergency situations.",
    bgColor: "bg-primary-500",
  },
  {
    icon: Briefcase,
    title: "Permanent Placement",
    description: "Long-term career opportunities connecting healthcare professionals with their ideal positions.",
    bgColor: "bg-accent-500",
  },
  {
    icon: GraduationCap,
    title: "Training & Development",
    description: "Comprehensive training programs to enhance skills and advance careers in healthcare.",
    bgColor: "bg-secondary",
  },
  {
    icon: Phone,
    title: "24/7 Support",
    description: "Round-the-clock support for both healthcare professionals and facilities we serve.",
    bgColor: "bg-primary-500",
  },
];

export default function ServicesGrid() {
  return (
    <section className="py-20 bg-background">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <div className="mb-4">
            <span className="text-sm font-medium uppercase tracking-wider text-white pl-[6px] pr-[6px] bg-[#f88f4a]">What We Offer</span>
          </div>
          <h2 className="text-3xl lg:text-4xl font-bold mb-4 text-[#3d59c5]">Our Healthcare Services</h2>
          <p className="text-lg text-slate-600 max-w-3xl mx-auto">
            We provide comprehensive healthcare staffing solutions tailored to meet the unique needs of healthcare facilities across the UK.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto">
          {services.map((service) => {
            const IconComponent = service.icon;
            return (
              <div
                key={service.title}
                className="p-6 rounded-lg shadow-sm hover:shadow-md transition-shadow duration-300 bg-white"
                data-testid={`service-card-${service.title.toLowerCase().replace(/\s+/g, '-')}`}
              >
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 rounded-md flex items-center justify-center flex-shrink-0 bg-[#4dd7dc]">
                    <IconComponent className="text-white w-6 h-6" />
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold text-slate-900 mb-2">{service.title}</h3>
                    <p className="text-slate-600 text-sm leading-relaxed">{service.description}</p>
                  </div>
                </div>
              </div>
            );
          })}
        </div>
      </div>
    </section>
  );
}
