import { Star } from "lucide-react";
import careImage from "@assets/carepic_1755818560976.png";

const testimonials = [
  {
    name: "Sarah Johnson",
    role: "Registered Nurse",
    content: "SmartGad Living helped me find the perfect position in a leading London hospital. Their support throughout the process was exceptional, and I couldn't be happier with my new role.",
    rating: 5,
    avatar: "https://images.unsplash.com/photo-1559839734-2b71ea197ec2?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&h=100",
  },
  {
    name: "Michael Chen",
    role: "Care Worker",
    content: "The team at SmartGad Living understood exactly what I was looking for in a care position. They matched me with a wonderful care home where I truly feel valued and appreciated.",
    rating: 5,
    avatar: careImage,
  },
  {
    name: "Emma Williams",
    role: "Healthcare Assistant",
    content: "From the initial consultation to starting my new role, SmartGad Living provided outstanding support. They truly care about finding the right fit for both the professional and the facility.",
    rating: 5,
    avatar: "https://images.unsplash.com/photo-1576091160399-112ba8d25d1f?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&h=100",
  },
];

export default function Testimonials() {
  return (
    <section className="py-20 bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <div className="mb-4">
            <span className="text-sm font-medium uppercase tracking-wider text-white pl-[6px] pr-[6px] bg-[#f88f4a]">Why Work For Us</span>
          </div>
          <h2 className="text-3xl lg:text-4xl font-bold mb-4 text-[#3d59c5]">What Our Healthcare Professionals Say</h2>
          <p className="text-lg text-slate-600 max-w-4xl mx-auto">
            Real experiences from nurses and care workers who found their perfect roles through SmartGad Living.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto">
          {testimonials.map((testimonial, index) => (
            <div
              key={testimonial.name}
              className="bg-slate-50 p-6 rounded-lg"
              data-testid={`testimonial-card-${index}`}
            >
              <div className="flex items-start space-x-4 mb-4">
                <img
                  src={testimonial.avatar}
                  alt={testimonial.name}
                  className="w-12 h-12 rounded-full object-cover"
                  loading="lazy"
                  decoding="async"
                />
                <div>
                  <h4 className="font-semibold text-[#3c59c2] text-sm">{testimonial.name}</h4>
                  <p className="text-sm text-slate-500">{testimonial.role}</p>
                </div>
              </div>
              
              <p className="text-slate-600 mb-4 italic text-sm leading-relaxed">
                "{testimonial.content}"
              </p>
              
              <div className="flex">
                {[...Array(testimonial.rating)].map((_, i) => (
                  <Star key={i} className="w-4 h-4 fill-accent-400 text-accent-400" />
                ))}
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
