import { Button } from "@/components/ui/button";
import { cn } from "@/lib/utils";

interface ConsultationCTAProps {
  variant?: "default" | "accent" | "outline";
  size?: "default" | "sm" | "lg";
  className?: string;
  onClick?: () => void;
}

export default function ConsultationCTA({ 
  variant = "accent", 
  size = "default", 
  className,
  onClick 
}: ConsultationCTAProps) {
  const handleClick = () => {
    if (onClick) {
      onClick();
    } else {
      // Scroll to contact section or navigate to contact page
      const contactSection = document.getElementById('contact');
      if (contactSection) {
        contactSection.scrollIntoView({ behavior: 'smooth' });
      } else {
        // If not on home page, navigate to contact
        window.location.href = '/contact';
      }
    }
  };

  return (
    <Button
      onClick={handleClick}
      variant={variant === "default" ? "default" : variant === "accent" ? "default" : "outline"}
      size={size}
      className="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm ring-offset-background focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg]:size-4 [&_svg]:shrink-0 h-10 px-4 py-2 text-white font-semibold transition-colors duration-200 shadow-sm hover:bg-accent-500/90 bg-[#fb914a]"
      data-testid="button-free-consultation"
    >Free Consultation
                      </Button>
  );
}
