import { Helmet } from "react-helmet-async";
import { Award, Users, Clock, Shield } from "lucide-react";
import ConsultationCTA from "@/components/ui/consultation-cta";

import cropped_image_female_caretaker_helping_senior_woman_walk_with_walker_home from "@assets/cropped-image-female-caretaker-helping-senior-woman-walk-with-walker-home.jpg";

export default function About() {
  

  const values = [
    {
      title: "Trust & Reliability",
      description: "We build lasting relationships based on transparency, integrity, and consistent delivery of exceptional service.",
      icon: Shield,
    },
    {
      title: "Professional Excellence",
      description: "Our commitment to maintaining the highest standards ensures quality placements that benefit both professionals and facilities.",
      icon: Award,
    },
    {
      title: "Personal Care",
      description: "We understand that each healthcare professional is unique, and we tailor our approach to meet individual needs and career goals.",
      icon: Users,
    },
  ];

  return (
    <>
      <Helmet>
        <title>About Us - SmartGad Living | Healthcare Recruitment Specialists</title>
        <meta name="description" content="Learn about SmartGad Living's mission to connect qualified healthcare professionals with rewarding career opportunities across the UK. Over 10 years of trusted service." />
      </Helmet>
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-primary-50 to-slate-100 py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <h1 className="text-4xl lg:text-5xl font-bold text-slate-900 leading-tight mb-6">
              About <span className="text-primary-600">SmartGad Living</span>
            </h1>
            <p className="text-xl text-slate-600 max-w-3xl mx-auto">
              Your trusted partner in healthcare recruitment, connecting passionate professionals with meaningful career opportunities across the United Kingdom.
            </p>
          </div>
        </div>
      </section>
      {/* Company Story */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid lg:grid-cols-2 gap-16 items-center">
            <div>
              <h2 className="text-3xl font-bold text-slate-900 mb-6">Our Story</h2>
              <p className="text-lg text-slate-600 mb-6 leading-relaxed">Founded with a simple mission: to bridge the gap between qualified healthcare professionals and the institutions that need them most. SmartGad Living emerged from a deep understanding of the challenges facing the UK healthcare sector.</p>
              <p className="text-lg text-slate-600 mb-6 leading-relaxed">
                Our founders, with extensive backgrounds in healthcare and recruitment, recognized the need for a more personal, professional approach to healthcare staffing. Today, we're proud to have facilitated hundreds of successful placements that have positively impacted patient care across the nation.
              </p>
              <p className="text-lg text-slate-600 mb-8 leading-relaxed">
                Every placement we make is a testament to our commitment to excellence, ensuring that both healthcare professionals and facilities receive the support they deserve to thrive in today's dynamic healthcare environment.
              </p>
              <ConsultationCTA />
            </div>
            <div>
              <img
                src={cropped_image_female_caretaker_helping_senior_woman_walk_with_walker_home}
                alt="Healthcare professionals working together in modern UK hospital"
                className="rounded-2xl shadow-2xl w-full h-auto"
              />
            </div>
          </div>
        </div>
      </section>
      
      {/* Values Section */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold text-slate-900 mb-4">Our Core Values</h2>
            <p className="text-xl text-slate-600 max-w-3xl mx-auto">
              The principles that guide every interaction and drive our commitment to excellence in healthcare recruitment
            </p>
          </div>

          <div className="grid lg:grid-cols-3 gap-8">
            {values.map((value, index) => {
              const IconComponent = value.icon;
              return (
                <div
                  key={index}
                  className="text-center p-8"
                  data-testid={`value-card-${index}`}
                >
                  <div className="w-20 h-20 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <IconComponent className="text-primary-600 w-10 h-10" />
                  </div>
                  <h3 className="text-xl font-semibold text-slate-900 mb-4">{value.title}</h3>
                  <p className="text-slate-600 leading-relaxed">{value.description}</p>
                </div>
              );
            })}
          </div>
        </div>
      </section>
      {/* CTA Section */}
      <section className="py-20 bg-primary-50">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl font-bold text-slate-900 mb-6">Ready to Take the Next Step?</h2>
          <p className="text-xl text-slate-600 mb-8">
            Whether you're a healthcare professional seeking your next opportunity or a facility looking for qualified staff, we're here to help you succeed.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <ConsultationCTA size="lg" />
            <button
              className="bg-white text-primary-600 hover:bg-slate-50 border border-primary-600 px-8 py-3 rounded-lg font-semibold transition-colors duration-200"
              data-testid="button-contact-us"
            >
              Contact Us Today
            </button>
          </div>
        </div>
      </section>
    </>
  );
}
