import { Helmet } from "react-helmet-async";
import { useState } from "react";
import Hero from "@/components/sections/hero";
import ServicesGrid from "@/components/sections/services-grid";
import Testimonials from "@/components/sections/testimonials";
import ConsultationCTA from "@/components/ui/consultation-cta";
import { Button } from "@/components/ui/button";
import { Dialog, DialogContent, DialogHeader, DialogTitle } from "@/components/ui/dialog";
import { Check, Heart, Shield, TrendingUp, X } from "lucide-react";

import nurseimages from "@assets/nurseimages.jpg";
import liveInCareImage from "@assets/her-caring-nature-makes-her-perfect-caregiver-shot-caregiver-assisting-her-senior-patient-home_1755817106755.jpg";
import companionshipCareImage from "@assets/senior-man-home-talking-female-nurse-care-worker-uniform-making-notes-folder_1755817276503.jpg";
import palliativeCareImage from "@assets/old-man-hospital_1755817528636.jpg";
import respiteCareImage from "@assets/Respite_Care_1755709152701.jpg";
import domiciliaryCareImage from "@assets/domiciliary-care_1755709152700.jpg";
import medicalHomeCareImage from "@assets/MedicalHomeCare_1756077868219.png";

export default function Home() {
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [modalContent, setModalContent] = useState({ title: "", content: "" });

  const openModal = (title: string, content: string) => {
    setModalContent({ title, content });
    setIsModalOpen(true);
  };

  const stats = [
    { number: "500+", label: "Professionals Placed" },
    { number: "150+", label: "Partner Facilities" },
    { number: "10+", label: "Years Experience" },
  ];

  const benefits = [
    {
      title: "Competitive Compensation",
      description: "Above-market rates with comprehensive benefits packages tailored to healthcare professionals.",
    },
    {
      title: "Flexible Scheduling",
      description: "Choose from permanent, temporary, or contract positions that fit your lifestyle and career goals.",
    },
    {
      title: "Professional Development",
      description: "Ongoing training opportunities and career advancement support to help you grow professionally.",
    },
    {
      title: "Personal Support",
      description: "Dedicated recruitment consultants who understand your needs and career aspirations.",
    },
  ];

  return (
    <>
      <Helmet>
        <title>SmartGad Living - Healthcare Professional Recruitment | UK Nurses & Care Workers</title>
        <meta name="description" content="Leading healthcare recruitment agency in the UK. Connect with qualified nurses and care workers. Professional, reliable healthcare staffing solutions." />
      </Helmet>
      <Hero />
      {/* Who We Are Section */}
      <section className="py-20 bg-background">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <div className="mb-4">
              <span className="text-sm font-medium uppercase tracking-wider text-white pl-[6px] pr-[6px] bg-[#f88f4a]">Who We Are</span>
            </div>
            
            <h2 className="text-3xl lg:text-4xl font-bold mb-6 leading-tight text-[#3d59c4]">Quality healthcare professionals with an excellent reputation</h2>
          </div>

          <div className="grid lg:grid-cols-5 gap-12 items-center">
            <div className="lg:col-span-3">
              
              <p className="text-lg text-slate-600 leading-relaxed mb-10">With years of experience in healthcare, SmartGad Living has established itself as a trusted partner for healthcare facilities across the United Kingdom. We understand the critical importance of having qualified, compassionate healthcare professionals in every role, and we're committed to building lasting relationships that benefit both professionals and organizations.</p>

              {/* Feature Points */}
              <div className="space-y-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 rounded-full flex items-center justify-center flex-shrink-0 bg-[#f9904b]">
                    <svg className="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/>
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold mb-2 text-[#3d59c5]">Enhanced Quality of Care</h3>
                    <p className="text-slate-600 leading-relaxed">
                      We match highly skilled, experienced, and dedicated healthcare professionals with the training and expertise to provide exceptional patient care.
                    </p>
                  </div>
                </div>

                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 rounded-full flex items-center justify-center flex-shrink-0 bg-[#fa914a]">
                    <svg className="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12,1L3,5V11C3,16.55 6.84,21.74 12,23C17.16,21.74 21,16.55 21,11V5L12,1M12,7C13.4,7 14.8,8.6 14.8,10V11.5C14.8,12.61 13.91,13.5 12.8,13.5H11.2C10.09,13.5 9.2,12.61 9.2,11.5V10C9.2,8.6 10.6,7 12,7Z"/>
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold mb-2 text-[#3d59c5]">Peace of Mind for Facilities</h3>
                    <p className="text-slate-600 leading-relaxed">
                      We provide comprehensive vetting and ongoing support, ensuring healthcare facilities receive qualified professionals they can trust and rely on.
                    </p>
                  </div>
                </div>

                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 rounded-full flex items-center justify-center flex-shrink-0 bg-[#fb914a]">
                    <svg className="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M16,6L18.29,8.29L13.41,13.17L9.41,9.17L2,16.59L3.41,18L9.41,12L13.41,16L19.71,9.71L22,12V6H16Z"/>
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold mb-2 text-[#3d59c5]">Professional Growth and Support</h3>
                    <p className="text-slate-600 leading-relaxed">
                      We offer tailored career guidance and ongoing professional development opportunities to help healthcare workers thrive in their careers.
                    </p>
                  </div>
                </div>
              </div>
            </div>

            <div className="lg:col-span-2">
              <img
                src="/nurse-with-tablet.jpg"
                alt="Healthcare professional providing compassionate care to patient"
                className="rounded-2xl shadow-xl w-full h-auto object-cover"
              />
            </div>
          </div>
        </div>
      </section>
      {/* Banner Section */}
      <section className="relative py-24 bg-cover bg-center" style={{ backgroundImage: 'url(/banner-elderly-care.jpg)' }}>
        {/* Dark overlay for text readability */}
        <div className="absolute inset-0 bg-black bg-opacity-60"></div>
        
        <div className="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-2xl ml-0 lg:ml-16">
            <h2 className="text-4xl lg:text-5xl font-bold text-white mb-6 leading-tight">
              Personalised Care for Your Loved Ones.
            </h2>
            <p className="text-xl text-white mb-8 leading-relaxed opacity-90">
              We offer a variety of care services to clients in their own homes because we know that's where they feel most at ease.
            </p>
            <Button
              size="lg"
              className="bg-[#3d59c5] hover:bg-[#3d59c5]/80 text-white px-8 py-4 text-lg font-semibold rounded-lg"
              data-testid="button-discover-more"
              onClick={() => {
                // Navigate to services page
                window.location.href = '/services';
              }}
            >
              Discover More
            </Button>
          </div>
        </div>
      </section>
      <ServicesGrid />
      {/* What we offer Section */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl lg:text-4xl font-bold mb-4 text-[#3d59c5]">Core Services</h2>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 max-w-7xl mx-auto">
            {/* Domiciliary Care Services */}
            <div className="relative h-64 rounded-2xl overflow-hidden group">
              <img 
                src={domiciliaryCareImage}
                alt="Domiciliary Care Services"
                className="w-full h-full object-cover"
                loading="lazy"
                decoding="async"
              />
              <div className="absolute inset-0 bg-black bg-opacity-50"></div>
              <div className="absolute inset-0 p-6 flex flex-col justify-between text-white">
                <div>
                  <h3 className="text-xl font-bold mb-2">Personal Care Services</h3>
                  <p className="text-sm opacity-90">Personal care is soft, you or a loved one at home while receiving high-quality care.</p>
                </div>
                <div className="flex justify-between items-end">
                  <Button 
                    className="bg-accent-500 hover:bg-accent-600 text-white px-4 py-2 text-sm rounded-lg"
                    data-testid="button-domiciliary-learn-more"
                    onClick={() => openModal(
                      "Personal Care Services",
                      "Our personal care allows you or your loved one to receive high-quality care. We offer a range of care and support services to help with your everyday needs and routines. Whether you need help with personal care or assistance with day-to-day tasks, our passionate and experienced care teams are here to provide the right support for you."
                    )}
                  >
                    Learn More
                  </Button>
                  <div className="w-8 h-8 bg-accent-500 rounded-full flex items-center justify-center">
                    <svg className="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                    </svg>
                  </div>
                </div>
              </div>
            </div>

            {/* Live-In Care Services */}
            <div className="relative h-64 rounded-2xl overflow-hidden group">
              <img 
                src={liveInCareImage}
                alt="Live-In Care Services"
                className="w-full h-full object-cover"
                loading="lazy"
                decoding="async"
              />
              <div className="absolute inset-0 bg-black bg-opacity-50"></div>
              <div className="absolute inset-0 p-6 flex flex-col justify-between text-white">
                <div>
                  <h3 className="text-xl font-bold mb-2">Live-In Care Services</h3>
                  <p className="text-sm opacity-90">Round-the-clock care and support within the comfort and security of your own home.</p>
                </div>
                <div className="flex justify-between items-end">
                  <Button 
                    className="bg-accent-500 hover:bg-accent-600 text-white px-4 py-2 text-sm rounded-lg"
                    data-testid="button-livein-learn-more"
                    onClick={() => openModal(
                      "Live-in Care Services",
                      "Our live-in care may offer consistent, adaptable care and company. Our live-in carers provide a very individualised and flexible degree of help. From household chores like cooking, cleaning, washing, and shopping to the provision of extra care services for requirements that are more complicated. Live-in care becomes an excellent choice to provide round-the-clock support by creating a special package to suit you."
                    )}
                  >
                    Learn More
                  </Button>
                  <div className="w-8 h-8 bg-accent-500 rounded-full flex items-center justify-center">
                    <svg className="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/>
                    </svg>
                  </div>
                </div>
              </div>
            </div>

            {/* Palliative Care Services */}
            <div className="relative h-64 rounded-2xl overflow-hidden group">
              <img 
                src={palliativeCareImage}
                alt="Palliative Care Services"
                className="w-full h-full object-cover"
                loading="lazy"
                decoding="async"
              />
              <div className="absolute inset-0 bg-black bg-opacity-50"></div>
              <div className="absolute inset-0 p-6 flex flex-col justify-between text-white">
                <div>
                  <h3 className="text-xl font-bold mb-2">End of Life / Palliative Care Services</h3>
                  <p className="text-sm opacity-90">Our in-home Palliative Care service strives for nothing less than the highest possible quality of life.</p>
                </div>
                <div className="flex justify-between items-end">
                  <Button 
                    className="bg-accent-500 hover:bg-accent-600 text-white px-4 py-2 text-sm rounded-lg"
                    data-testid="button-palliative-learn-more"
                    onClick={() => openModal(
                      "Palliative Care Services",
                      "We know what it's like to worry and feel sad when a loved one has a disease that that is terminal. We hope that by giving you a personalised service, we can help you feel less stressed and make the most of your time together. Our skilled carers provide palliative homecare to patients with terminal illnesses who want to remain in their own homes. We try to help our clients and their families by being sensitive and reassuring."
                    )}
                  >
                    Learn More
                  </Button>
                  <div className="w-8 h-8 bg-accent-500 rounded-full flex items-center justify-center">
                    <svg className="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/>
                    </svg>
                  </div>
                </div>
              </div>
            </div>

            {/* Respite Care Services */}
            <div className="relative h-64 rounded-2xl overflow-hidden group">
              <img 
                src={respiteCareImage}
                alt="Respite Care Services"
                className="w-full h-full object-cover"
                loading="lazy"
                decoding="async"
              />
              <div className="absolute inset-0 bg-black bg-opacity-50"></div>
              <div className="absolute inset-0 p-6 flex flex-col justify-between text-white">
                <div>
                  <h3 className="text-xl font-bold mb-2">Respite Care Services</h3>
                  <p className="text-sm opacity-90">We recognise that taking care of someone one might leave you very little time for yourself.</p>
                </div>
                <div className="flex justify-between items-end">
                  <Button 
                    className="bg-accent-500 hover:bg-accent-600 text-white px-4 py-2 text-sm rounded-lg"
                    data-testid="button-respite-learn-more"
                    onClick={() => openModal(
                      "Respite Care Services",
                      "Even more so when you're a carer; we get that you need some time alone now and again. Caregiving may be exhausting, but with respite services, you can take a break while still knowing that your loved one is in good hands. We have trained staff available to assist you. The individual providing care and the person receiving care can both greatly benefit from respite care. If you feel it would be beneficial, we can be there for you 24/7/365."
                    )}
                  >
                    Learn More
                  </Button>
                  <div className="w-8 h-8 bg-accent-500 rounded-full flex items-center justify-center">
                    <svg className="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                    </svg>
                  </div>
                </div>
              </div>
            </div>

            {/* Companionship Care Services */}
            <div className="relative h-64 rounded-2xl overflow-hidden group">
              <img 
                src={companionshipCareImage}
                alt="Companionship Care Services"
                className="w-full h-full object-cover"
                loading="lazy"
                decoding="async"
              />
              <div className="absolute inset-0 bg-black bg-opacity-50"></div>
              <div className="absolute inset-0 p-6 flex flex-col justify-between text-white">
                <div>
                  <h3 className="text-xl font-bold mb-2">Companionship Care Services</h3>
                  <p className="text-sm opacity-90">Companionship services are tailor-suited for people who want to stay in their home but no longer wish to be alone.</p>
                </div>
                <div className="flex justify-between items-end">
                  <Button 
                    className="bg-accent-500 hover:bg-accent-600 text-white px-4 py-2 text-sm rounded-lg"
                    data-testid="button-companionship-learn-more"
                    onClick={() => openModal(
                      "Companionship Care Services",
                      "Loneliness is a bigger problem than simply an emotional experience. Providing tailored services such as home assistance, companionship, social trips, and activities based on the individual's needs. This allows you or your loved ones to continue living freely while fulfilling personal and medical needs. We take the time to uncover what our consumers used to appreciate but may not have had the opportunity to experience. We'll help them reconnect with their interests."
                    )}
                  >
                    Learn More
                  </Button>
                  <div className="w-8 h-8 bg-accent-500 rounded-full flex items-center justify-center">
                    <svg className="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M16 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zm4 18v-6h2.5l-2.54-7.63A1.5 1.5 0 0 0 18.54 8H16c-.8 0-1.54.37-2 1l-3 4v7h2v7h3v-7h2zm-7.5-10.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5S11 9.17 11 10s.67 1.5 1.5 1.5zM5.5 6c1.11 0 2-.89 2-2s-.89-2-2-2-2 .89-2 2 .89 2 2 2zm1.5 1H5c-.8 0-1.54.37-2 1l-3 4v7h2v7h3v-7h2v-7l-1-1.34V8.5c0-.28.22-.5.5-.5h1V7z"/>
                    </svg>
                  </div>
                </div>
              </div>
            </div>

            {/* Reablement Care */}
            <div className="relative h-64 rounded-2xl overflow-hidden group">
              <img 
                src="https://images.unsplash.com/photo-1559757148-5c350d0d3c56?ixlib=rb-4.0.3&auto=format&fit=crop&w=600&h=400"
                alt="Dementia Care"
                className="w-full h-full object-cover"
                loading="lazy"
                decoding="async"
              />
              <div className="absolute inset-0 bg-black bg-opacity-50"></div>
              <div className="absolute inset-0 p-6 flex flex-col justify-between text-white">
                <div>
                  <h3 className="text-xl font-bold mb-2">Dementia Care</h3>
                  <p className="text-sm opacity-90">Our specialized dementia care services provide compassionate support for individuals and families affected by dementia and Alzheimer's disease.</p>
                </div>
                <div className="flex justify-between items-end">
                  <Button 
                    className="bg-accent-500 hover:bg-accent-600 text-white px-4 py-2 text-sm rounded-lg"
                    data-testid="button-dementia-learn-more"
                    onClick={() => openModal(
                      "Dementia Care",
                      "We understand the challenges that come with caring for someone with dementia or Alzheimer's disease. Our specialized dementia care services provide person-centered support that maintains dignity, promotes independence, and ensures safety. Our trained carers are experienced in managing the various stages of dementia, from early-stage support to complex care needs. We focus on creating familiar routines, engaging activities, and providing emotional support for both clients and their families during this difficult journey."
                    )}
                  >
                    Learn More
                  </Button>
                  <div className="w-8 h-8 bg-accent-500 rounded-full flex items-center justify-center">
                    <svg className="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                  </div>
                </div>
              </div>
            </div>

            {/* Home Help Care */}
            <div className="relative h-64 rounded-2xl overflow-hidden group">
              <img 
                src="https://images.unsplash.com/photo-1558618666-fcd25c85cd64?ixlib=rb-4.0.3&auto=format&fit=crop&w=600&h=400"
                alt="Home Help Care"
                className="w-full h-full object-cover"
                loading="lazy"
                decoding="async"
              />
              <div className="absolute inset-0 bg-black bg-opacity-50"></div>
              <div className="absolute inset-0 p-6 flex flex-col justify-between text-white">
                <div>
                  <h3 className="text-xl font-bold mb-2">Home Help Care</h3>
                  <p className="text-sm opacity-90">Practical domestic assistance to help you maintain your independence and quality of life at home.</p>
                </div>
                <div className="flex justify-between items-end">
                  <Button 
                    className="bg-accent-500 hover:bg-accent-600 text-white px-4 py-2 text-sm rounded-lg"
                    data-testid="button-homehelp-learn-more"
                    onClick={() => openModal(
                      "Home Help Care",
                      "Our home help care services are designed to support you with everyday household tasks that may have become challenging. From light housekeeping and laundry to shopping and meal preparation, our experienced care assistants help you maintain your independence while ensuring your home remains comfortable and well-maintained. We understand that keeping up with household chores can become overwhelming, and our flexible service can be tailored to meet your specific needs and schedule."
                    )}
                  >
                    Learn More
                  </Button>
                  <div className="w-8 h-8 bg-accent-500 rounded-full flex items-center justify-center">
                    <svg className="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/>
                    </svg>
                  </div>
                </div>
              </div>
            </div>

            {/* Wake-in/Sleep-in Care */}
            <div className="relative h-64 rounded-2xl overflow-hidden group">
              <img 
                src={medicalHomeCareImage}
                alt="Wake-in/Sleep-in Care"
                className="w-full h-full object-cover"
                loading="lazy"
                decoding="async"
              />
              <div className="absolute inset-0 bg-black bg-opacity-50"></div>
              <div className="absolute inset-0 p-6 flex flex-col justify-between text-white">
                <div>
                  <h3 className="text-xl font-bold mb-2">Wake-in/Sleep-in Care</h3>
                  <p className="text-sm opacity-90">Overnight support services providing peace of mind and assistance when you need it most.</p>
                </div>
                <div className="flex justify-between items-end">
                  <Button 
                    className="bg-accent-500 hover:bg-accent-600 text-white px-4 py-2 text-sm rounded-lg"
                    data-testid="button-wakein-learn-more"
                    onClick={() => openModal(
                      "Wake-in/Sleep-in Care",
                      "Our wake-in and sleep-in care services provide overnight support for those who need assistance during the night hours. Whether you require a carer to sleep in your home for peace of mind or need active support throughout the night, we offer flexible overnight care solutions. Sleep-in care involves a carer staying overnight in your home, providing assistance if needed. Wake-in care provides active support throughout the night for those with more complex needs. Both services ensure you or your loved one can rest peacefully knowing professional help is available."
                    )}
                  >
                    Learn More
                  </Button>
                  <div className="w-8 h-8 bg-accent-500 rounded-full flex items-center justify-center">
                    <svg className="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"/>
                    </svg>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      {/* Why Choose Us Section */}
      <section className="py-20 bg-slate-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <div className="mb-4">
              <span className="text-sm font-medium uppercase tracking-wider text-white pl-[6px] pr-[6px] bg-[#f88f4a]">Why Choose Us</span>
            </div>
            
            <h2 className="text-3xl lg:text-4xl font-bold mb-6 leading-tight text-[#3d59c5]">Compassionate and Professional Care</h2>
          </div>

          <div className="grid lg:grid-cols-5 gap-12 items-center">
            <div className="lg:col-span-3">
              
              <p className="text-lg text-slate-600 leading-relaxed mb-10">
                We firmly believe that each individual and family is unique and that the care and support they require should be tailored to their personality, preferences, life experiences, and requirements, thereby providing a personalised care plan.
              </p>

              {/* Feature Points */}
              <div className="space-y-6">
                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 rounded-full flex items-center justify-center flex-shrink-0 bg-[#fb914a]">
                    <svg className="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M16,6L18.29,8.29L13.41,13.17L9.41,9.17L2,16.59L3.41,18L9.41,12L13.41,16L19.71,9.71L22,12V6H16Z"/>
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold text-[#3c59c2] mb-2">Professional Carers</h3>
                    <p className="text-slate-600 leading-relaxed">
                      Our team consists of highly trained, experienced, and compassionate carers who are committed to providing the highest standard of care.
                    </p>
                  </div>
                </div>

                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 rounded-full flex items-center justify-center flex-shrink-0 bg-[#fb924a]">
                    <svg className="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12,1L3,5V11C3,16.55 6.84,21.74 12,23C17.16,21.74 21,16.55 21,11V5L12,1M12,7C13.4,7 14.8,8.6 14.8,10V11.5C14.8,12.61 13.91,13.5 12.8,13.5H11.2C10.09,13.5 9.2,12.61 9.2,11.5V10C9.2,8.6 10.6,7 12,7Z"/>
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold text-[#3c59c2] mb-2">Safety and Comfort</h3>
                    <p className="text-slate-600 leading-relaxed">
                      We prioritise the safety, comfort, and wellbeing of our clients, ensuring they feel secure and supported in their own homes.
                    </p>
                  </div>
                </div>

                <div className="flex items-start space-x-4">
                  <div className="w-12 h-12 rounded-full flex items-center justify-center flex-shrink-0 bg-[#fc924a]">
                    <svg className="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/>
                    </svg>
                  </div>
                  <div>
                    <h3 className="text-lg font-semibold text-[#3c59c2] mb-2">Comprehensive Care Services</h3>
                    <p className="text-slate-600 leading-relaxed">
                      From personal care to companionship, we offer a full range of services designed to meet all aspects of our clients' care needs.
                    </p>
                  </div>
                </div>
              </div>
            </div>

            <div className="lg:col-span-2">
              <img
                src="/why-choose-us-care.jpg"
                alt="Compassionate care showing hands holding together in support"
                className="rounded-2xl shadow-xl w-full h-auto object-cover"
                loading="lazy"
                decoding="async"
              />
            </div>
          </div>
        </div>
      </section>
      <Testimonials />
      {/* Join Team Section */}
      <section className="py-20 bg-background">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl lg:text-4xl font-bold text-[#3c59c2] mb-4">Join Our Healthcare Team</h2>
            <p className="text-xl text-slate-600 max-w-3xl mx-auto">
              Take the next step in your healthcare career with opportunities that value your skills and dedication
            </p>
          </div>

          <div className="grid lg:grid-cols-2 gap-16 items-center">
            <div>
              <img
                src={nurseimages}
                alt="Professional medical team in modern UK hospital setting"
                className="rounded-2xl shadow-2xl w-full h-auto"
                loading="lazy"
                decoding="async"
              />
            </div>

            <div>
              <h3 className="text-2xl font-bold text-[#3c59c2] mb-6">Why Choose SmartGad Living?</h3>
              
              <div className="space-y-6">
                {benefits.map((benefit, index) => (
                  <div key={index} className="flex items-start space-x-4" data-testid={`benefit-${index}`}>
                    <div className={`w-8 h-8 ${index % 2 === 0 ? 'bg-primary-100' : 'bg-accent-100'} rounded-full flex items-center justify-center flex-shrink-0 mt-1`}>
                      <Check className={`${index % 2 === 0 ? 'text-primary-600' : 'text-accent-600'} w-4 h-4`} />
                    </div>
                    <div>
                      <h4 className="font-semibold text-[#3c59c2] mb-2">{benefit.title}</h4>
                      <p className="text-slate-600">{benefit.description}</p>
                    </div>
                  </div>
                ))}
              </div>

              <div className="mt-8 p-6 bg-primary-50 rounded-xl border border-primary-200">
                <h4 className="font-semibold text-[#3c59c2] mb-3">Ready to Start Your Journey?</h4>
                <p className="text-slate-600 mb-4">Join hundreds of healthcare professionals who have found their ideal role through SmartGad Living.</p>
                <div className="flex flex-col sm:flex-row gap-3">
                  <Button
                    className="bg-[#244e61] text-white font-semibold hover:bg-[#244e61]/90 transition-colors duration-200"
                    data-testid="button-apply-now"
                  >
                    Apply Now
                  </Button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      {/* Modal for Learn More content */}
      <Dialog open={isModalOpen} onOpenChange={setIsModalOpen}>
        <DialogContent className="max-w-2xl">
          <DialogHeader>
            <DialogTitle className="text-2xl font-bold text-[#3c59c2] mb-4">
              {modalContent.title}
            </DialogTitle>
          </DialogHeader>
          <div className="text-slate-600 leading-relaxed text-lg">
            {modalContent.content}
          </div>
        </DialogContent>
      </Dialog>
    </>
  );
}
