import { Helmet } from "react-helmet-async";
import ServicesGrid from "@/components/sections/services-grid";
import ConsultationCTA from "@/components/ui/consultation-cta";
import { CheckCircle, Clock, Shield, Users } from "lucide-react";

import elderly_patient_hospital from "@assets/elderly-patient-hospital.jpg";

import side_view_smiley_nurse_patient from "@assets/side-view-smiley-nurse-patient.jpg";

export default function Services() {
  const processSteps = [
    {
      step: 1,
      title: "Initial Consultation",
      description: "We begin with a comprehensive discussion about your career goals, experience, and preferences.",
      icon: Users,
    },
    {
      step: 2,
      title: "Skills Assessment",
      description: "Our team evaluates your qualifications, certifications, and professional background.",
      icon: CheckCircle,
    },
    {
      step: 3,
      title: "Job Matching",
      description: "We identify suitable positions that align with your skills, experience, and career aspirations.",
      icon: Shield,
    },
    {
      step: 4,
      title: "Placement & Support",
      description: "Ongoing support throughout the application process and continued guidance after placement.",
      icon: Clock,
    },
  ];

  const benefits = [
    "Full DBS check support and guidance",
    "Professional reference verification",
    "Qualification and certification validation",
    "Competitive salary negotiation",
    "Flexible working arrangements",
    "Ongoing career development support",
    "24/7 emergency support line",
    "Compliance training and updates",
  ];

  return (
    <>
      <Helmet>
        <title>Healthcare Services - SmartGad Living | Nursing & Care Worker Recruitment</title>
        <meta name="description" content="Comprehensive healthcare recruitment services including registered nurses, care workers, healthcare assistants, and temporary staffing solutions across the UK." />
      </Helmet>
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-primary-50 to-slate-100 py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <h1 className="text-4xl lg:text-5xl font-bold text-slate-900 leading-tight mb-6">
              Healthcare <span className="text-primary-600">Services</span>
            </h1>
            <p className="text-xl text-slate-600 max-w-3xl mx-auto">
              Comprehensive recruitment solutions designed specifically for the UK healthcare sector, connecting qualified professionals with meaningful career opportunities.
            </p>
          </div>
        </div>
      </section>
      <ServicesGrid />
      {/* Process Section */}
      <section className="py-20 bg-slate-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold text-slate-900 mb-4">Our Recruitment Process</h2>
            <p className="text-xl text-slate-600 max-w-3xl mx-auto">
              A streamlined, professional approach designed to find the perfect match for your skills and career goals
            </p>
          </div>

          <div className="grid lg:grid-cols-4 gap-8">
            {processSteps.map((step) => {
              const IconComponent = step.icon;
              return (
                <div
                  key={step.step}
                  className="text-center"
                  data-testid={`process-step-${step.step}`}
                >
                  <div className="relative mb-6">
                    <div className="w-20 h-20 bg-primary-600 rounded-full flex items-center justify-center mx-auto mb-4">
                      <IconComponent className="text-white w-10 h-10" />
                    </div>
                    <div className="absolute -top-2 -right-2 w-8 h-8 bg-accent-500 rounded-full flex items-center justify-center text-white font-bold text-sm">
                      {step.step}
                    </div>
                  </div>
                  <h3 className="text-xl font-semibold text-slate-900 mb-3">{step.title}</h3>
                  <p className="text-slate-600 leading-relaxed">{step.description}</p>
                </div>
              );
            })}
          </div>
        </div>
      </section>
      {/* Benefits Section */}
      <section className="py-20 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid lg:grid-cols-2 gap-16 items-center">
            <div>
              <h2 className="text-3xl font-bold text-slate-900 mb-6">What We Offer</h2>
              <p className="text-lg text-slate-600 mb-8 leading-relaxed">
                Our comprehensive support extends beyond simple job placement. We're committed to ensuring your success throughout your healthcare career journey.
              </p>
              
              <div className="grid md:grid-cols-2 gap-4">
                {benefits.map((benefit, index) => (
                  <div
                    key={index}
                    className="flex items-center space-x-3"
                    data-testid={`benefit-${index}`}
                  >
                    <CheckCircle className="text-primary-600 w-5 h-5 flex-shrink-0" />
                    <span className="text-slate-700">{benefit}</span>
                  </div>
                ))}
              </div>
            </div>

            <div className="space-y-6">
              <img
                src={side_view_smiley_nurse_patient}
                alt="Healthcare professionals in consultation"
                className="rounded-xl shadow-lg w-full h-64 object-cover"
              />
              <img
                src={elderly_patient_hospital}
                alt="Nurse providing patient care"
                className="rounded-xl shadow-lg w-full h-48 object-cover"
              />
            </div>
          </div>
        </div>
      </section>
      {/* CTA Section */}
      <section className="py-20 bg-gradient-to-r from-primary-500 to-accent-500">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <h2 className="text-3xl font-bold text-white mb-6">Ready to Advance Your Healthcare Career?</h2>
          <p className="text-xl text-white mb-8 opacity-90">
            Let our experienced recruitment specialists help you find the perfect opportunity that matches your skills and career goals.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button
              className="bg-white text-primary-600 hover:bg-slate-100 px-8 py-3 rounded-lg font-semibold transition-colors duration-200"
              data-testid="button-get-started"
            >
              Get Started Today
            </button>
            <ConsultationCTA
              variant="outline"
              className="border-white text-white hover:bg-white hover:text-primary-600"
            />
          </div>
        </div>
      </section>
    </>
  );
}
